/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file    nandflash.h
 *
 * \brief   Defines the module register defines for NAND Flash 
 *
 * This header file contains the Macros definitions and NAND flash
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _nandflash_H_
#define _nandflash_H_
/*========================
 * Includes
 *========================
 */
 
#include "DM388_types.h"
#include "DM388_EVM.h"
/*=========================
 * Defines
 *=========================
 */

#define NANDFLASH_BASE                  0x50000000  // Low CS
#define NANDFLASH_BLOCKS                2048 
#define NANDFLASH_PAGESPERBLOCK         64
#define NANDFLASH_PAGES                 (NANDFLASH_BLOCKS * NANDFLASH_PAGESPERBLOCK)
#define NANDFLASH_PAGESIZE              2048
#define NANDFLASH_SPARESIZE             64

/* Number of blocks to test the erase, read/write */
#define NANDFLASH_BLOCKS_TEST		4

#define NANDFLASH_CLE   *( volatile UINT16* )( NANDFLASH_BASE + 0x7C )
#define NANDFLASH_ALE   *( volatile UINT16* )( NANDFLASH_BASE + 0x80 )
#define NANDFLASH_DATA  *( volatile UINT16* )( NANDFLASH_BASE + 0x84 )

#define CMD_READ                    0x0000
#define CMD_READID                  0x0090
#define CMD_READ_CONFIRM            0x0030
#define CMD_PROGRAM                 0x0080
#define CMD_PROGRAM_CONFIRM         0x0010
#define CMD_ERASE                   0x0060
#define CMD_ERASE_CONFIRM           0x00d0
#define CMD_STATUS                  0x0070
#define CMD_RESET                   0x00ff

#define DM388_GPMC_WPn				26

/*
 *======================
 *Function Declarations
 *======================
 */

INT32 nandflash_test(void *testargs);
INT32 nand_init(void);
INT32 nand_eraseBlock(UINT32 blocknum);
INT32 nand_readPage(UINT32 pagenum, UINT16 *buf, UINT16 len);
INT32 nand_writePage(UINT32 pagenum, UINT16 *buf, UINT16 len);

#endif /* _nandflash_H_ */
